package com.hero.objects.characteristics;

import java.math.BigDecimal;
import java.text.NumberFormat;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.util.Constants;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class BaseSize extends Characteristic {

	private static String xmlID = "BASESIZE";

	private double startWidth;

	private double startLength;

	private int startDCV;

	public BaseSize(Element root) {
		super(root, BaseSize.xmlID);
	}

	@Override
	protected void init(Element root) {
		super.init(root);
		startWidth = .5;
		startLength = 1;
		startDCV = -4;
		String check = XMLUtility.getValue(root, "STARTWIDTH");
		if (check != null && check.trim().length() > 0) {
			try {
				startWidth = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(root, "STARTHEIGHT");
		if (check != null && check.trim().length() > 0) {
			try {
				startLength = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(root, "STARTDCV");
		if (check != null && check.trim().length() > 0) {
			try {
				startDCV = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
	}

	@Override
	public int getType() {
		return Constants.SIZE;
	}

	@Override
	public String getRoll() {
		return "";
	}

	@Override
	public int getHeightIncreaseLevels() {
		if (super.getHeightIncreaseLevels() == 0) {
			return 1;
		} else {
			return super.getHeightIncreaseLevels();
		}
	}

	@Override
	public int getWidthIncreaseLevels() {
		if (super.getWidthIncreaseLevels() == 0) {
			return 1;
		} else {
			return super.getWidthIncreaseLevels();
		}
	}

	@Override
	public String getDisplayNotes() {
		double length = startLength;
		if (getLevels() != 0) {
			length = length
					* Math
							.pow(
									getHeightIncrease(),
									((double) getLevels() / (double) getHeightIncreaseLevels()));
		}
		double width = startWidth;
		if (getLevels() != 0) {
			width = width
					* Math
							.pow(
									getWidthIncrease(),
									((double) getLevels() / (double) getWidthIncreaseLevels()));
		}
		double area = length * width;
		double volume = length * width * width;
		long m = 100;
		if (getLevels() != 0) {
			int widMul = getLevels() / getMassMultiplierLevels();
			int step1 = (int) Rounder.roundHalfUp(Math.pow(getMassMultiplier(),
					widMul));
			int step2 = (int) Rounder.roundHalfUp(Math.pow(getMassMultiplier(),
					widMul + 1));
			int dif = step2 - step1;
			m = m
					* (long) (Rounder.roundHalfUp(Math.pow(getMassMultiplier(),
							widMul)) + dif * (double) getLevels()
							% getMassMultiplierLevels()
							/ getMassMultiplierLevels());
		}
		int dcv = startDCV;
		int mul = getDcvIncrease() < 0 ? -1 : 1;
		if (getDcvIncreaseLevels() != 0) {
			dcv += mul
					* (int) Rounder.roundDown(Math.abs(getDcvIncrease())
							* (double) getLevels()
							/ (double) getDcvIncreaseLevels());
		}

		int ocv = Math.abs(dcv);

		BigDecimal l = new BigDecimal(length);
		l = l.setScale(2, BigDecimal.ROUND_HALF_UP);
		BigDecimal w = new BigDecimal(width);
		w = w.setScale(2, BigDecimal.ROUND_HALF_UP);
		BigDecimal a = new BigDecimal(area);
		a = a.setScale(2, BigDecimal.ROUND_HALF_UP);
		BigDecimal v = new BigDecimal(volume);
		v = v.setScale(2, BigDecimal.ROUND_HALF_UP);
		NumberFormat format = NumberFormat.getInstance();
		String ret = "Length " + format.format(l.doubleValue()) + "\",  Width "
				+ format.format(w.doubleValue()) + "\",   Area "
				+ format.format(a.doubleValue()) + "\"   " + "DCV " + dcv;
		if (HeroDesigner.getActiveTemplate().is6E()) {
			ret = "Length " + format.format(l.doubleValue()) + "m,  Width "
					+ format.format(w.doubleValue()) + "m,  Height "
					+ format.format(w.doubleValue()) + "m,  Volume "
					+ format.format(v.doubleValue()) + "m^3   " + "OCV +" + ocv;
		}

		return ret;
	}
}